<?php
/**
 * Single Post Options
 */

$wp_customize->add_section(
	'web_news_single_page_options',
	array(
		'title' => esc_html__( 'Single Post Options', 'web-news' ),
		'panel' => 'web_news_theme_options_panel',
	)
);

// Enable single post category setting.
$wp_customize->add_setting(
	'web_news_enable_single_category',
	array(
		'default'           => true,
		'sanitize_callback' => 'web_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Web_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'web_news_enable_single_category',
		array(
			'label'    => esc_html__( 'Enable Category', 'web-news' ),
			'settings' => 'web_news_enable_single_category',
			'section'  => 'web_news_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable single post author setting.
$wp_customize->add_setting(
	'web_news_enable_single_author',
	array(
		'default'           => true,
		'sanitize_callback' => 'web_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Web_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'web_news_enable_single_author',
		array(
			'label'    => esc_html__( 'Enable Author', 'web-news' ),
			'settings' => 'web_news_enable_single_author',
			'section'  => 'web_news_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable single post date setting.
$wp_customize->add_setting(
	'web_news_enable_single_date',
	array(
		'default'           => true,
		'sanitize_callback' => 'web_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Web_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'web_news_enable_single_date',
		array(
			'label'    => esc_html__( 'Enable Date', 'web-news' ),
			'settings' => 'web_news_enable_single_date',
			'section'  => 'web_news_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable single post tag setting.
$wp_customize->add_setting(
	'web_news_enable_single_tag',
	array(
		'default'           => true,
		'sanitize_callback' => 'web_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Web_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'web_news_enable_single_tag',
		array(
			'label'    => esc_html__( 'Enable Post Tag', 'web-news' ),
			'settings' => 'web_news_enable_single_tag',
			'section'  => 'web_news_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable single post related Posts setting.
$wp_customize->add_setting(
	'web_news_enable_single_post_related_posts',
	array(
		'default'           => true,
		'sanitize_callback' => 'web_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Web_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'web_news_enable_single_post_related_posts',
		array(
			'label'    => esc_html__( 'Enable Related posts', 'web-news' ),
			'settings' => 'web_news_enable_single_post_related_posts',
			'section'  => 'web_news_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Single post related Posts title label.
$wp_customize->add_setting(
	'web_news_related_posts_title',
	array(
		'default'           => __( 'Related Posts', 'web-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'web_news_related_posts_title',
	array(
		'label'           => esc_html__( 'Related Posts Title', 'web-news' ),
		'section'         => 'web_news_single_page_options',
		'settings'        => 'web_news_related_posts_title',
		'active_callback' => function( $control ) {
			return ( $control->manager->get_setting( 'web_news_enable_single_post_related_posts' )->value() );
		},
	)
);
