<?php
/**
 * Sidebar settings.
 */

$wp_customize->add_section(
	'web_news_sidebar_option',
	array(
		'title' => esc_html__( 'Sidebar Options', 'web-news' ),
		'panel' => 'web_news_theme_options_panel',
	)
);

// Sidebar Option - Global Sidebar Position.
$wp_customize->add_setting(
	'web_news_sidebar_position',
	array(
		'sanitize_callback' => 'web_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'web_news_sidebar_position',
	array(
		'label'   => esc_html__( 'Global Sidebar Position', 'web-news' ),
		'section' => 'web_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'web-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'web-news' ),
		),
	)
);

// Sidebar Option - Post Sidebar Position.
$wp_customize->add_setting(
	'web_news_post_sidebar_position',
	array(
		'sanitize_callback' => 'web_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'web_news_post_sidebar_position',
	array(
		'label'   => esc_html__( 'Post Sidebar Position', 'web-news' ),
		'section' => 'web_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'web-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'web-news' ),
		),
	)
);

// Sidebar Option - Page Sidebar Position.
$wp_customize->add_setting(
	'web_news_page_sidebar_position',
	array(
		'sanitize_callback' => 'web_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'web_news_page_sidebar_position',
	array(
		'label'   => esc_html__( 'Page Sidebar Position', 'web-news' ),
		'section' => 'web_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'web-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'web-news' ),
		),
	)
);
