<?php
/**
 * Secondary Sidebar settings
 */

$wp_customize->add_section(
	'web_news_secondary_sidebar_option',
	array(
		'title' => esc_html__( 'Secondary Sidebar Position', 'web-news' ),
		'panel' => 'web_news_theme_options_panel',
	)
);

// Secondary Sidebar Option - Sidebar Position.
$wp_customize->add_setting(
	'web_news_secondary_sidebar_position',
	array(
		'sanitize_callback' => 'web_news_sanitize_select',
		'default'           => 'secondary-right-position',
	)
);

$wp_customize->add_control(
	'web_news_secondary_sidebar_position',
	array(
		'label'   => esc_html__( 'Secondary Sidebar Position', 'web-news' ),
		'section' => 'web_news_secondary_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'secondary-right-position' => esc_html__( 'Shift Right Position', 'web-news' ),
			'secondary-left-position'  => esc_html__( 'Shift Left Position', 'web-news' ),
		),
	)
);
