<?php
/**
 * Pagination setting
 */

// Pagination setting.
$wp_customize->add_section(
	'web_news_pagination',
	array(
		'title' => esc_html__( 'Pagination', 'web-news' ),
		'panel' => 'web_news_theme_options_panel',
	)
);

// Pagination enable setting.
$wp_customize->add_setting(
	'web_news_pagination_enable',
	array(
		'default'           => true,
		'sanitize_callback' => 'web_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Web_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'web_news_pagination_enable',
		array(
			'label'    => esc_html__( 'Enable Pagination.', 'web-news' ),
			'settings' => 'web_news_pagination_enable',
			'section'  => 'web_news_pagination',
			'type'     => 'checkbox',
		)
	)
);

// Pagination - Pagination Style.
$wp_customize->add_setting(
	'web_news_pagination_type',
	array(
		'default'           => 'default',
		'sanitize_callback' => 'web_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'web_news_pagination_type',
	array(
		'label'           => esc_html__( 'Pagination Style', 'web-news' ),
		'section'         => 'web_news_pagination',
		'type'            => 'select',
		'choices'         => array(
			'default' => __( 'Default (Older/Newer)', 'web-news' ),
			'numeric' => __( 'Numeric', 'web-news' ),
		),
		'active_callback' => function( $control ) {
			return ( $control->manager->get_setting( 'web_news_pagination_enable' )->value() );
		},
	)
);
