<?php
/**
 * Menu Options
 */

// Menu Options section.
$wp_customize->add_section(
	'web_news_menu_options',
	array(
		'title' => esc_html__( 'Menu Options', 'web-news' ),
		'panel' => 'nav_menus',
	)
);

// Menu Section Horizontal Line.
$wp_customize->add_setting(
	'web_news_banner_horizontal_line',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Web_News_Customize_Horizontal_Line(
		$wp_customize,
		'web_news_banner_horizontal_line',
		array(
			'settings' => 'web_news_banner_horizontal_line',
			'section'  => 'web_news_menu_options',
			'type'     => 'hr',
		)
	)
);

// Menu Section Advertisement Image.
$wp_customize->add_setting(
	'web_news_advertisement_image',
	array(
		'default'           => '',
		'sanitize_callback' => 'web_news_sanitize_image',
	)
);

$wp_customize->add_control(
	new WP_Customize_Image_Control(
		$wp_customize,
		'web_news_advertisement_image',
		array(
			'label'    => esc_html__( 'Advertisement Image', 'web-news' ),
			'settings' => 'web_news_advertisement_image',
			'section'  => 'web_news_menu_options',
		)
	)
);

// Menu Section Advertisement Url
$wp_customize->add_setting(
	'web_news_advertisement_url',
	array(
		'default'           => '#',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'web_news_advertisement_url',
	array(
		'label'    => esc_html__( 'Button Url', 'web-news' ),
		'settings' => 'web_news_advertisement_url',
		'section'  => 'web_news_menu_options',
		'type'     => 'url',
	)
);
