<?php
/**
 * Header Options
 */

$wp_customize->add_section(
	'web_news_header_options',
	array(
		'title' => esc_html__( 'Header Options', 'web-news' ),
		'panel' => 'web_news_theme_options_panel',
	)
);


	// Header Section Advertisement Image.
$wp_customize->add_setting(
	'web_news_advertisement_image',
	array(
		'default'           => '',
		'sanitize_callback' => 'web_news_sanitize_image',
	)
);

$wp_customize->add_control(
	new WP_Customize_Image_Control(
		$wp_customize,
		'web_news_advertisement_image',
		array(
			'label'    => esc_html__( 'Advertisement Image', 'web-news' ),
			'settings' => 'web_news_advertisement_image',
			'section'  => 'web_news_header_options',
		)
	)
);

	// Header Advertisement Url.
$wp_customize->add_setting(
	'web_news_advertisement_url',
	array(
		'default'           => '#',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'web_news_advertisement_url',
	array(
		'label'    => esc_html__( 'Advertisement Url', 'web-news' ),
		'settings' => 'web_news_advertisement_url',
		'section'  => 'web_news_header_options',
		'type'     => 'url',
	)
);

