<?php
/**
 * Back To Top settings
 */

$wp_customize->add_section(
	'web_news_back_to_top_section',
	array(
		'title' => esc_html__( 'Scroll Up ( Back To Top )', 'web-news' ),
		'panel' => 'web_news_theme_options_panel',
	)
);

// Scroll to top enable setting.
$wp_customize->add_setting(
	'web_news_enable_scroll_to_top',
	array(
		'default'           => true,
		'sanitize_callback' => 'web_news_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Web_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'web_news_enable_scroll_to_top',
		array(
			'label'    => esc_html__( 'Enable scroll to top.', 'web-news' ),
			'settings' => 'web_news_enable_scroll_to_top',
			'section'  => 'web_news_back_to_top_section',
			'type'     => 'checkbox',
		)
	)
);
