<?php
/**
 * Adore Themes Customizer
 *
 * @package Web News
 *
 * Breaking News Section
 */

$wp_customize->add_section(
	'web_news_breaking_news_section',
	array(
		'title' => esc_html__( 'Breaking News Section', 'web-news' ),
		'panel' => 'web_news_frontpage_panel',
	)
);

// Breaking News section enable settings.
$wp_customize->add_setting(
	'web_news_breaking_news_section_enable',
	array(
		'default'           => false,
		'sanitize_callback' => 'web_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Web_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'web_news_breaking_news_section_enable',
		array(
			'label'    => esc_html__( 'Enable Breaking News Section', 'web-news' ),
			'type'     => 'checkbox',
			'settings' => 'web_news_breaking_news_section_enable',
			'section'  => 'web_news_breaking_news_section',
		)
	)
);

// Breaking News title settings.
$wp_customize->add_setting(
	'web_news_breaking_news_title',
	array(
		'default'           => __( 'Breaking News', 'web-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'web_news_breaking_news_title',
	array(
		'label'           => esc_html__( 'Title', 'web-news' ),
		'section'         => 'web_news_breaking_news_section',
		'active_callback' => 'web_news_if_breaking_news_enabled',
	)
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'web_news_breaking_news_title',
		array(
			'selector'            => '.news-ticker-section .acme-news-ticker-label',
			'settings'            => 'web_news_breaking_news_title',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
			'render_callback'     => 'web_news_breaking_news_title_text_partial',
		)
	);
}

// breaking_news content type settings.
$wp_customize->add_setting(
	'web_news_breaking_news_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'web_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'web_news_breaking_news_content_type',
	array(
		'label'           => esc_html__( 'Content type:', 'web-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'web-news' ),
		'section'         => 'web_news_breaking_news_section',
		'type'            => 'select',
		'active_callback' => 'web_news_if_breaking_news_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'web-news' ),
			'category' => esc_html__( 'Category', 'web-news' ),
		),
	)
);

for ( $i = 1; $i <= 5; $i++ ) {
	// breaking_news post setting.
	$wp_customize->add_setting(
		'web_news_breaking_news_post_' . $i,
		array(
			'sanitize_callback' => 'web_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'web_news_breaking_news_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'web-news' ), $i ),
			'section'         => 'web_news_breaking_news_section',
			'type'            => 'select',
			'choices'         => web_news_get_post_choices(),
			'active_callback' => 'web_news_breaking_news_section_content_type_post_enabled',
		)
	);

}

// breaking_news category setting.
$wp_customize->add_setting(
	'web_news_breaking_news_category',
	array(
		'sanitize_callback' => 'web_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'web_news_breaking_news_category',
	array(
		'label'           => esc_html__( 'Category', 'web-news' ),
		'section'         => 'web_news_breaking_news_section',
		'type'            => 'select',
		'choices'         => web_news_get_post_cat_choices(),
		'active_callback' => 'web_news_breaking_news_section_content_type_category_enabled',
	)
);

/*========================Active Callback==============================*/
function web_news_if_breaking_news_enabled( $control ) {
	return $control->manager->get_setting( 'web_news_breaking_news_section_enable' )->value();
}
function web_news_breaking_news_section_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'web_news_breaking_news_content_type' )->value();
	return web_news_if_breaking_news_enabled( $control ) && ( 'post' === $content_type );
}
function web_news_breaking_news_section_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'web_news_breaking_news_content_type' )->value();
	return web_news_if_breaking_news_enabled( $control ) && ( 'category' === $content_type );
}

/*========================Partial Refresh==============================*/
if ( ! function_exists( 'web_news_breaking_news_title_text_partial' ) ) :
	// Title.
	function web_news_breaking_news_title_text_partial() {
		return esc_html( get_theme_mod( 'web_news_breaking_news_title' ) );
	}
endif;
