<?php
/**
 * Adore Themes Customizer
 *
 * @package Web News
 *
 * Banner Section
 */

$wp_customize->add_section(
	'web_news_banner_section',
	array(
		'title' => esc_html__( 'Banner Section', 'web-news' ),
		'panel' => 'web_news_frontpage_panel',
	)
);

// Banner enable setting.
$wp_customize->add_setting(
	'web_news_banner_section_enable',
	array(
		'default'           => false,
		'sanitize_callback' => 'web_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Web_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'web_news_banner_section_enable',
		array(
			'label'    => esc_html__( 'Enable Banner Section', 'web-news' ),
			'type'     => 'checkbox',
			'settings' => 'web_news_banner_section_enable',
			'section'  => 'web_news_banner_section',
		)
	)
);

// banner content type settings.
$wp_customize->add_setting(
	'web_news_banner_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'web_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'web_news_banner_content_type',
	array(
		'label'           => esc_html__( 'Content type:', 'web-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'web-news' ),
		'section'         => 'web_news_banner_section',
		'type'            => 'select',
		'active_callback' => 'web_news_if_banner_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'web-news' ),
			'category' => esc_html__( 'Category', 'web-news' ),
		),
	)
);

for ( $i = 1; $i <= 4; $i++ ) {
	// banner post setting.
	$wp_customize->add_setting(
		'web_news_banner_post_' . $i,
		array(
			'sanitize_callback' => 'web_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'web_news_banner_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'web-news' ), $i ),
			'section'         => 'web_news_banner_section',
			'type'            => 'select',
			'choices'         => web_news_get_post_choices(),
			'active_callback' => 'web_news_banner_section_content_type_post_enabled',
		)
	);

}

// banner category setting.
$wp_customize->add_setting(
	'web_news_banner_category',
	array(
		'sanitize_callback' => 'web_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'web_news_banner_category',
	array(
		'label'           => esc_html__( 'Category', 'web-news' ),
		'section'         => 'web_news_banner_section',
		'type'            => 'select',
		'choices'         => web_news_get_post_cat_choices(),
		'active_callback' => 'web_news_banner_section_content_type_category_enabled',
	)
);

/*========================Active Callback==============================*/
function web_news_if_banner_enabled( $control ) {
	return $control->manager->get_setting( 'web_news_banner_section_enable' )->value();
}
function web_news_banner_section_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'web_news_banner_content_type' )->value();
	return web_news_if_banner_enabled( $control ) && ( 'post' === $content_type );
}
function web_news_banner_section_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'web_news_banner_content_type' )->value();
	return web_news_if_banner_enabled( $control ) && ( 'category' === $content_type );
}
